Ext.data.JsonP.sol_common_HttpUtils({"tagname":"class","name":"sol.common.HttpUtils","autodetected":{"aliases":true,"alternateClassNames":true,"extends":true,"mixins":true,"uses":true,"members":true,"code_type":true,"singleton":true},"files":[{"filename":"lib_sol.common.HttpUtils.js","href":"lib_sol.common.HttpUtils.html#sol-common-HttpUtils"}],"author":[{"tagname":"author","name":"MW, ELO Digital Office GmbH","email":null}],"version":["1.0"],"eloas":true,"eloix":true,"elojc":true,"requires":["sol.common.AsUtils","sol.common.WfUtils"],"aliases":{},"alternateClassNames":[],"extends":"sol.Base","mixins":[],"uses":[],"members":[{"name":"requiredConfig","tagname":"cfg","owner":"sol.Base","id":"cfg-requiredConfig","meta":{"protected":true}},{"name":"$className","tagname":"property","owner":"sol.Base","id":"property-S-className","meta":{"protected":true}},{"name":"logger","tagname":"property","owner":"sol.Base","id":"property-logger","meta":{"protected":true}},{"name":"$super","tagname":"method","owner":"sol.Base","id":"method-S-super","meta":{"private":true}},{"name":"buildResultObj","tagname":"method","owner":"sol.common.HttpUtils","id":"method-buildResultObj","meta":{"private":true}},{"name":"convertByteArrayToString","tagname":"method","owner":"sol.common.HttpUtils","id":"method-convertByteArrayToString","meta":{"private":true}},{"name":"convertStringToByteArray","tagname":"method","owner":"sol.common.HttpUtils","id":"method-convertStringToByteArray","meta":{"private":true}},{"name":"encodeBase64","tagname":"method","owner":"sol.common.HttpUtils","id":"method-encodeBase64","meta":{}},{"name":"getPasswordAuthentication","tagname":"method","owner":"sol.common.HttpUtils","id":"method-getPasswordAuthentication","meta":{"private":true}},{"name":"initialize","tagname":"method","owner":"sol.Base","id":"method-initialize","meta":{"private":true}},{"name":"inputStreamToString","tagname":"method","owner":"sol.common.HttpUtils","id":"method-inputStreamToString","meta":{"private":true}},{"name":"logRequestProperties","tagname":"method","owner":"sol.common.HttpUtils","id":"method-logRequestProperties","meta":{"private":true}},{"name":"prepareRequest","tagname":"method","owner":"sol.common.HttpUtils","id":"method-prepareRequest","meta":{"private":true}},{"name":"readResponse","tagname":"method","owner":"sol.common.HttpUtils","id":"method-readResponse","meta":{"private":true}},{"name":"resolveUrl","tagname":"method","owner":"sol.common.HttpUtils","id":"method-resolveUrl","meta":{"private":true}},{"name":"sendGet","tagname":"method","owner":"sol.common.HttpUtils","id":"method-sendGet","meta":{"private":true}},{"name":"sendPost","tagname":"method","owner":"sol.common.HttpUtils","id":"method-sendPost","meta":{"private":true}},{"name":"sendRequest","tagname":"method","owner":"sol.common.HttpUtils","id":"method-sendRequest","meta":{}}],"code_type":"ext_define","singleton":true,"id":"class-sol.common.HttpUtils","classIcon":"icon-singleton","superclasses":["sol.Base"],"subclasses":[],"mixedInto":[],"parentMixins":[],"html":"<div><pre class=\"hierarchy\"><h4>Hierarchy</h4><div class='subclass first-child'><a href='#!/api/sol.Base' rel='sol.Base' class='docClass'>sol.Base</a><div class='subclass '><strong>sol.common.HttpUtils</strong></div></div><h4>Requires</h4><div class='dependency'><a href='#!/api/sol.common.AsUtils' rel='sol.common.AsUtils' class='docClass'>sol.common.AsUtils</a></div><div class='dependency'><a href='#!/api/sol.common.WfUtils' rel='sol.common.WfUtils' class='docClass'>sol.common.WfUtils</a></div><h4>Files</h4><div class='dependency'><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils' target='_blank'>lib_sol.common.HttpUtils.js</a></div></pre><div class='doc-contents'><p>HTTP request utilities</p>\n      <p class='version-tag'>Version: <b>1.0</b></p>\n</div><div class='members'><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-cfg'>Config options</h3><div class='subsection'><div id='cfg-requiredConfig' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-cfg-requiredConfig' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-cfg-requiredConfig' class='name expandable'>requiredConfig</a> : Array<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>List of required config properties. ...</div><div class='long'><p>List of required config properties. <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a> throws an exception if one of the properties is null or undefined.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-property'>Properties</h3><div class='subsection'><div id='property-S-className' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-S-className' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-S-className' class='name expandable'>$className</a> : Object<span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'><p>{String}\nname of the class including its namespace.</p>\n</div><div class='long'><p>{String}\nname of the class including its namespace.</p>\n</div></div></div><div id='property-logger' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-property-logger' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-property-logger' class='name expandable'>logger</a> : <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a><span class=\"signature\"><span class='protected' >protected</span></span></div><div class='description'><div class='short'>Logger for this class instance. ...</div><div class='long'><p>Logger for this class instance. This logger is created by <a href=\"#!/api/sol.Base-method-initialize\" rel=\"sol.Base-method-initialize\" class=\"docClass\">sol.Base.initialize</a>.</p>\n\n<p>Please see <a href=\"#!/api/sol.Logger\" rel=\"sol.Logger\" class=\"docClass\">sol.Logger</a> class documentation for more information.</p>\n</div></div></div></div></div><div class='members-section'><div class='definedBy'>Defined By</div><h3 class='members-title icon-method'>Methods</h3><div class='subsection'><div id='method-S-super' class='member first-child inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-S-super' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-S-super' class='name expandable'>$super</a>( <span class='pre'>superClassName, functionName, arguments</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Calls a function of a superclass thanks to its name. ...</div><div class='long'><p>Calls a function of a superclass thanks to its name. Superclass must be part of the calling objects class hierarchy.</p>\n\n<p><b>Please note that calling superclass functions might lead to an infinitive loop if misused. Please validate that none class other than the classes superclass is passed as the superclass parent.</b></p>\n\n<pre><code>me.$super(superClassName, functionName, attributesArray);\n</code></pre>\n\n<p>A basic example of the initialize-function will look as followed.</p>\n\n<pre><code>me.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", [config]);\nme.$super(\"<a href=\"#!/api/sol.Base\" rel=\"sol.Base\" class=\"docClass\">sol.Base</a>\", \"initialize\", arguments);\n</code></pre>\n\n<p>A word on performance: The superclass name must be passed since the js rhino engine does not allow accessing the caller of the callee due to performance reasons.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>superClassName</span> : String<div class='sub-desc'><p>name of the super class.</p>\n</div></li><li><span class='pre'>functionName</span> : String<div class='sub-desc'><p>name of the function that should be called.</p>\n</div></li><li><span class='pre'>arguments</span> : Object[]<div class='sub-desc'><p>list of arguments that should be passed to the function.</p>\n</div></li></ul></div></div></div><div id='method-buildResultObj' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-buildResultObj' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-buildResultObj' class='name expandable'>buildResultObj</a>( <span class='pre'>url</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Builds a response object ...</div><div class='long'><p>Builds a response object</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Response object</p>\n</div></li></ul></div></div></div><div id='method-convertByteArrayToString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-convertByteArrayToString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-convertByteArrayToString' class='name expandable'>convertByteArrayToString</a>( <span class='pre'>bytes</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts a byte array to a string ...</div><div class='long'><p>Converts a byte array to a string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>bytes</span> : Byte[]<div class='sub-desc'>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-convertStringToByteArray' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-convertStringToByteArray' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-convertStringToByteArray' class='name expandable'>convertStringToByteArray</a>( <span class='pre'>str</span> ) : Byte[]<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts a string to a byte array ...</div><div class='long'><p>Converts a string to a byte array</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>String</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Byte[]</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-encodeBase64' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-encodeBase64' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-encodeBase64' class='name expandable'>encodeBase64</a>( <span class='pre'>str</span> ) : String<span class=\"signature\"></span></div><div class='description'><div class='short'>Returns a Base64 encoded string ...</div><div class='long'><p>Returns a Base64 encoded string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>str</span> : String<div class='sub-desc'><p>String</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Base64 encoded string</p>\n</div></li></ul></div></div></div><div id='method-getPasswordAuthentication' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-getPasswordAuthentication' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-getPasswordAuthentication' class='name expandable'>getPasswordAuthentication</a>( <span class='pre'></span> ) : javax.mail.PasswordAuthentication<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class='pa'>Returns</h3><ul><li><span class='pre'>javax.mail.PasswordAuthentication</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-initialize' class='member  inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><a href='#!/api/sol.Base' rel='sol.Base' class='defined-in docClass'>sol.Base</a><br/><a href='source/lib_Class.html#sol-Base-method-initialize' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.Base-method-initialize' class='name expandable'>initialize</a>( <span class='pre'>config</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Initialize class. ...</div><div class='long'><p>Initialize class.\nThis function is called after the class was instantiated.</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>parameters as defined. See documentation for more details.</p>\n</div></li></ul></div></div></div><div id='method-inputStreamToString' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-inputStreamToString' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-inputStreamToString' class='name expandable'>inputStreamToString</a>( <span class='pre'>inputStream</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Converts the content of an input stream into a string ...</div><div class='long'><p>Converts the content of an input stream into a string</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>inputStream</span> : java.io.InputStream<div class='sub-desc'><p>Input Stream</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>Content as string</p>\n</div></li></ul></div></div></div><div id='method-logRequestProperties' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-logRequestProperties' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-logRequestProperties' class='name expandable'>logRequestProperties</a>( <span class='pre'>urlConn</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'> ...</div><div class='long'>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>urlConn</span> : java.net.HttpURLConnection<div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-prepareRequest' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-prepareRequest' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-prepareRequest' class='name expandable'>prepareRequest</a>( <span class='pre'>urlString, config</span> ) : java.net.HttpURLConnection<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Prepares a HTTP request ...</div><div class='long'><p>Prepares a HTTP request</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>urlString</span> : String<div class='sub-desc'><p>URL</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>HTTP request configuration object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.net.HttpURLConnection</span><div class='sub-desc'>\n</div></li></ul></div></div></div><div id='method-readResponse' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-readResponse' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-readResponse' class='name expandable'>readResponse</a>( <span class='pre'>urlConn, resultObj</span> )<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Read HTTP response ...</div><div class='long'><p>Read HTTP response</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>urlConn</span> : java.net.HttpURLConnection<div class='sub-desc'><p>HTTP connection</p>\n</div></li><li><span class='pre'>resultObj</span> : Object<div class='sub-desc'><p>Result object</p>\n</div></li></ul></div></div></div><div id='method-resolveUrl' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-resolveUrl' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-resolveUrl' class='name expandable'>resolveUrl</a>( <span class='pre'>url, config</span> ) : String<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Resolve URL ...</div><div class='long'><p>Resolve URL</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>HTTP request configuration object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>String</span><div class='sub-desc'><p>URL</p>\n</div></li></ul></div></div></div><div id='method-sendGet' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-sendGet' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-sendGet' class='name expandable'>sendGet</a>( <span class='pre'>url, config</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Sends a HTTP-GET request ...</div><div class='long'><p>Sends a HTTP-GET request</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>HTTP request configuration object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Response object</p>\n</div></li></ul></div></div></div><div id='method-sendPost' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-sendPost' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-sendPost' class='name expandable'>sendPost</a>( <span class='pre'>url, data, config</span> ) : Object<span class=\"signature\"><span class='private' >private</span></span></div><div class='description'><div class='short'>Sends a HTTP-POST request ...</div><div class='long'><p>Sends a HTTP-POST request</p>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li><li><span class='pre'>data</span> : String<div class='sub-desc'><p>Data</p>\n</div></li><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>HTTP request configuration object</p>\n</div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>Object</span><div class='sub-desc'><p>Response object</p>\n</div></li></ul></div></div></div><div id='method-sendRequest' class='member  not-inherited'><a href='#' class='side expandable'><span>&nbsp;</span></a><div class='title'><div class='meta'><span class='defined-in' rel='sol.common.HttpUtils'>sol.common.HttpUtils</span><br/><a href='source/lib_sol.common.HttpUtils.html#sol-common-HttpUtils-method-sendRequest' target='_blank' class='view-source'>view source</a></div><a href='#!/api/sol.common.HttpUtils-method-sendRequest' class='name expandable'>sendRequest</a>( <span class='pre'>config</span> ) : java.net.HttpURLConnection<span class=\"signature\"></span></div><div class='description'><div class='short'>Sends a HTTP request. ...</div><div class='long'><p>Sends a HTTP request.</p>\n\n<p>Example:</p>\n\n<pre><code>var responseObj = <a href=\"#!/api/sol.common.HttpUtils-method-sendRequest\" rel=\"sol.common.HttpUtils-method-sendRequest\" class=\"docClass\">sol.common.HttpUtils.sendRequest</a>({\n  url: \"{{eloWfBaseUrl}}/apps/rest/cmd/app/deploy\",\n  method: \"post\",\n  connectTimeout: 10000,\n  readTimeout: 60000,\n  contentType: \"application/json;charset=UTF-8\",\n  params: { \"Key2\": \"Value2\" }\n  addTicket: true,\n  cookies: { \"Key1\": \"Value1\" },\n  addCookieTicket: true\n});\n</code></pre>\n\n<p>   var responseObj = <a href=\"#!/api/sol.common.HttpUtils-method-sendRequest\" rel=\"sol.common.HttpUtils-method-sendRequest\" class=\"docClass\">sol.common.HttpUtils.sendRequest</a>({\n      url: \"https://example.com\"\n      trustAllHosts: true,\n      trustAllCerts: true\n   });</p>\n\n<p>URL placeholders:</p>\n\n<pre><code>{{eloWfBaseUrl}} ELOwf base URL\n{{eloAsBaseUrl}} ELOas base URL\n{{ticket}} ELO authorization ticket\n</code></pre>\n\n<p>Response object:</p>\n\n<pre><code>{\n  \"responseCode\": 200,\n  \"responseOk\": true,\n  \"content\": \"\",\n  \"errorMessage\": \"\"\n}\n</code></pre>\n<h3 class=\"pa\">Parameters</h3><ul><li><span class='pre'>config</span> : Object<div class='sub-desc'><p>HTTP request configuration object</p>\n<ul><li><span class='pre'>url</span> : String<div class='sub-desc'><p>URL</p>\n</div></li><li><span class='pre'>method</span> : String (optional)<div class='sub-desc'><p>Request method, e.g. <code>get</code>, <code>post</code> or <code>put</code></p>\n<p>Defaults to: <code>get</code></p></div></li><li><span class='pre'>connectTimeout</span> : String<div class='sub-desc'><p>Connect timeout</p>\n</div></li><li><span class='pre'>readTimeout</span> : String<div class='sub-desc'><p>Read timeout</p>\n</div></li><li><span class='pre'>contentType</span> : String<div class='sub-desc'><p>Content type</p>\n</div></li><li><span class='pre'>user</span> : String<div class='sub-desc'><p>User name</p>\n</div></li><li><span class='pre'>password</span> : String<div class='sub-desc'><p>Password</p>\n</div></li><li><span class='pre'>authType</span> : String (optional)<div class='sub-desc'><p>Authentification type</p>\n<p>Defaults to: <code>Basic</code></p></div></li><li><span class='pre'>params</span> : Object<div class='sub-desc'><p>Map of key-value pairs which will be submitted as HTTP parameters</p>\n</div></li><li><span class='pre'>addTicket</span> : String<div class='sub-desc'><p>. If true the ELO authorization ticket will be added as HTTP parameter</p>\n</div></li><li><span class='pre'>cookies</span> : Object<div class='sub-desc'><p>Map of key-value pairs which will be added as cookies</p>\n</div></li><li><span class='pre'>data</span> : Object<div class='sub-desc'><p>Data</p>\n</div></li><li><span class='pre'>encodeData</span> : Boolean (optional)<div class='sub-desc'><p>Encode data</p>\n<p>Defaults to: <code>true</code></p></div></li><li><span class='pre'>dataObj</span> : Object<div class='sub-desc'><p>Data object</p>\n</div></li><li><span class='pre'>addCookieTicket</span> : String<div class='sub-desc'><p>. If true the ELO authorization ticket will be added as cookie</p>\n</div></li><li><span class='pre'>requestProperties</span> : Object<div class='sub-desc'><p>Request properties</p>\n</div></li><li><span class='pre'>resolve</span> : Boolean<div class='sub-desc'><p>Enrich the URL with specific variables (<code>{{eloWfBaseUrl}}</code>, <code>{{ticket}}</code>) and given parameters</p>\n</div></li><li><span class='pre'>proxyHost</span> : String<div class='sub-desc'><p>Proxy host</p>\n</div></li><li><span class='pre'>proxyPort</span> : String<div class='sub-desc'><p>Proxy port</p>\n</div></li></ul></div></li></ul><h3 class='pa'>Returns</h3><ul><li><span class='pre'>java.net.HttpURLConnection</span><div class='sub-desc'><p>httpConn. HTTP connection</p>\n</div></li></ul></div></div></div></div></div></div></div>","meta":{"eloas":true,"eloix":true,"elojc":true,"singleton":true}});